/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm.kerberos;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.FileSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.zeppelin.realm.kerberos.KerberosToken;
import org.apache.zeppelin.realm.kerberos.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosRealm
extends AuthorizingRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosRealm.class);
    private String principal = null;
    private String keytab = null;
    private String nameRules = "DEFAULT";
    private long tokenMaxInactiveInterval = -1L;
    private long tokenValidity = 36000L;
    private String cookieDomain = null;
    private String cookiePath = "/";
    private boolean isCookiePersistent = false;
    private String signatureSecretFile = null;
    private String signatureSecretProvider = "file";
    private String logout = "logout";
    private Boolean logoutAPI = true;
    private String providerUrl = "https://domain.example.com/";
    private String redirectParam = "originalUrl";
    private static final String AUTH_TYPE = "type";
    private static final String SIGNATURE_SECRET = "signature.secret";
    private static final String SIGNATURE_SECRET_FILE = "signature.secret.file";
    private static final String AUTH_TOKEN_MAX_INACTIVE_INTERVAL = "token.max-inactive-interval";
    private static final String AUTH_TOKEN_VALIDITY = "token.tokenValidity";
    private static final String COOKIE_DOMAIN = "cookie.domain";
    private static final String COOKIE_PATH = "cookie.path";
    private static final String COOKIE_PERSISTENT = "cookie.persistent";
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String NAME_RULES = "kerberos.name.rules";
    private static final String SIGNER_SECRET_PROVIDER = "signer.secret.provider";
    private static final String LOGOUT = "logout";
    private static Signer signer = null;
    private SignerSecretProvider secretProvider = null;
    private boolean destroySecretProvider = true;
    private GSSManager gssManager = null;
    private Subject serverSubject = null;
    private Properties config = null;
    private Groups hadoopGroups;

    public boolean supports(org.apache.shiro.authc.AuthenticationToken token) {
        return token instanceof KerberosToken;
    }

    protected void onInit() {
        super.onInit();
        this.config = this.getConfiguration();
        try {
            String[] spnegoPrincipals;
            if (this.principal == null || this.principal.trim().length() == 0) {
                throw new RuntimeException("Principal not defined in configuration");
            }
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new RuntimeException("Keytab not defined in configuration");
            }
            File keytabFile = new File(this.keytab);
            if (!keytabFile.exists()) {
                throw new RuntimeException("Keytab file does not exist: " + this.keytab);
            }
            if (this.principal.equals("*")) {
                spnegoPrincipals = KerberosUtil.getPrincipalNames(this.keytab, Pattern.compile("HTTP/.*"));
                if (spnegoPrincipals.length == 0) {
                    throw new RuntimeException("Principals do not exist in the keytab");
                }
            } else {
                spnegoPrincipals = new String[]{this.principal};
            }
            KeyTab keytabInstance = KeyTab.getInstance(keytabFile);
            this.serverSubject = new Subject();
            this.serverSubject.getPrivateCredentials().add(keytabInstance);
            for (String spnegoPrincipal : spnegoPrincipals) {
                KerberosPrincipal krbPrincipal = new KerberosPrincipal(spnegoPrincipal);
                LOGGER.info("Using keytab {}, for principal {}", (Object)this.keytab, (Object)krbPrincipal);
                this.serverSubject.getPrincipals().add(krbPrincipal);
            }
            if (this.nameRules == null || this.nameRules.trim().length() == 0) {
                LOGGER.warn("No auth_to_local rules defined, DEFAULT will be used.");
                this.nameRules = "DEFAULT";
            }
            KerberosName.setRules((String)this.nameRules);
            if (null == this.gssManager) {
                try {
                    this.gssManager = Subject.doAs(this.serverSubject, GSSManager::getInstance);
                    LOGGER.trace("SPNEGO gssManager initialized.");
                }
                catch (PrivilegedActionException ex) {
                    throw ex.getException();
                }
            }
            if (null == signer) {
                this.initializeSecretProvider();
            }
            Configuration hadoopConfig = new Configuration();
            this.hadoopGroups = new Groups(hadoopConfig);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeSecretProvider() throws ServletException {
        try {
            this.secretProvider = this.constructSecretProvider();
            this.destroySecretProvider = true;
            signer = new Signer(this.secretProvider);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private SignerSecretProvider constructSecretProvider() throws Exception {
        FileSignerSecretProvider provider;
        String secretProvider = this.config.getProperty(SIGNER_SECRET_PROVIDER);
        if (this.config.getProperty(SIGNATURE_SECRET_FILE) == null) {
            secretProvider = "random";
        }
        if ("file".equals(secretProvider)) {
            try {
                provider = new FileSignerSecretProvider();
                provider.init(this.config, null, this.tokenValidity);
                LOGGER.info("File based secret signer initialized.");
            }
            catch (Exception e) {
                LOGGER.info("Unable to initialize FileSignerSecretProvider, falling back to use random secrets.");
                provider = new RandomSignerSecretProvider();
                provider.init(this.config, null, this.tokenValidity);
                LOGGER.info("Random secret signer initialized.");
            }
        } else if ("random".equals(secretProvider)) {
            provider = new RandomSignerSecretProvider();
            provider.init(this.config, null, this.tokenValidity);
            LOGGER.info("Random secret signer initialized.");
        } else {
            throw new RuntimeException("Custom secret signer not implemented yet. Use 'file' or 'random'.");
        }
        return provider;
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) throws AuthorizationException {
        Set<String> roles = this.mapGroupPrincipals(principals.getPrimaryPrincipal().toString());
        return new SimpleAuthorizationInfo(roles);
    }

    public Set<String> mapGroupPrincipals(String mappedPrincipalName) throws AuthorizationException {
        HashSet<String> groups;
        try {
            this.hadoopGroups.refresh();
            List groupList = this.hadoopGroups.getGroups(mappedPrincipalName);
            LOGGER.debug(String.format("group found %s, %s", mappedPrincipalName, groupList.toString()));
            groups = new HashSet(groupList);
        }
        catch (IOException e) {
            if (!e.toString().contains("No groups found for user")) {
                LOGGER.info(String.format("errorGettingUserGroups for %s", mappedPrincipalName));
                throw new AuthorizationException((Throwable)e);
            }
            LOGGER.info(String.format("No groups found for user %s", mappedPrincipalName));
            groups = new HashSet<String>();
        }
        return groups;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(org.apache.shiro.authc.AuthenticationToken authenticationToken) throws org.apache.shiro.authc.AuthenticationException {
        if (null != authenticationToken) {
            KerberosToken kerberosToken = (KerberosToken)authenticationToken;
            SimpleAccount account = new SimpleAccount(kerberosToken.getPrincipal(), kerberosToken.getCredentials(), kerberosToken.getClass().getName());
            account.addRole(this.mapGroupPrincipals((String)kerberosToken.getPrincipal()));
            return account;
        }
        return null;
    }

    public void doKerberosAuth(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean unauthorizedResponse = true;
        int errCode = 401;
        AuthenticationException authenticationEx = null;
        Object httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isHttps = "https".equals(httpRequest.getScheme());
        try {
            AuthenticationToken token;
            boolean newToken = false;
            try {
                token = this.getToken((HttpServletRequest)httpRequest);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Got token {} from httpRequest {}", (Object)token, (Object)this.getRequestURL((HttpServletRequest)httpRequest));
                    if (null != token) {
                        LOGGER.debug("token.isExpired() = " + token.isExpired());
                    }
                }
            }
            catch (AuthenticationException ex) {
                LOGGER.warn("AuthenticationToken ignored: " + ex.getMessage());
                if (!ex.getMessage().equals("Empty token")) {
                    authenticationEx = ex;
                }
                token = null;
            }
            if (this.managementOperation(token, (HttpServletRequest)httpRequest, httpResponse)) {
                if (token == null || token.isExpired()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Request [{}] triggering authentication. handler: {}", (Object)this.getRequestURL((HttpServletRequest)httpRequest), ((Object)((Object)this)).getClass());
                    }
                    if ((token = this.authenticate((HttpServletRequest)httpRequest, httpResponse)) != null && token != AuthenticationToken.ANONYMOUS && token.getExpires() != 0L) {
                        token.setExpires(System.currentTimeMillis() + this.getTokenValidity() * 1000L);
                    }
                    newToken = true;
                }
                if (token != null) {
                    unauthorizedResponse = false;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Request [{}] user [{}] authenticated", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token.getUserName());
                    }
                    final AuthenticationToken authToken = token;
                    httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                        public String getAuthType() {
                            return authToken.getType();
                        }

                        public String getRemoteUser() {
                            return authToken.getUserName();
                        }

                        public Principal getUserPrincipal() {
                            return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                        }
                    };
                    if (!newToken && !this.isCookiePersistent() && this.getTokenMaxInactiveInterval() > 0L) {
                        token.setExpires(token.getExpires());
                        newToken = true;
                    }
                    if (newToken && !token.isExpired() && token != AuthenticationToken.ANONYMOUS) {
                        String signedToken = signer.sign(token.toString());
                        KerberosRealm.createAuthCookie(httpResponse, signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), this.isCookiePersistent(), isHttps);
                    }
                    KerberosToken kerberosToken = new KerberosToken(token.getUserName(), token.toString());
                    SecurityUtils.getSubject().login((org.apache.shiro.authc.AuthenticationToken)kerberosToken);
                    this.doFilter(filterChain, (HttpServletRequest)httpRequest, httpResponse);
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("managementOperation returned false for request {}. token: {}", (Object)this.getRequestURL((HttpServletRequest)httpRequest), (Object)token);
                }
                unauthorizedResponse = false;
            }
        }
        catch (AuthenticationException ex) {
            errCode = 403;
            authenticationEx = ex;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authentication exception: " + ex.getMessage(), (Throwable)ex);
            }
            LOGGER.warn("Authentication exception: " + ex.getMessage());
        }
        if (unauthorizedResponse && !httpResponse.isCommitted()) {
            KerberosRealm.createAuthCookie(httpResponse, "", this.getCookieDomain(), this.getCookiePath(), 0L, this.isCookiePersistent(), isHttps);
            if (errCode == 401 && !httpResponse.containsHeader("WWW-Authenticate")) {
                errCode = 403;
            }
            if (authenticationEx == null) {
                httpResponse.sendError(errCode, "Authentication required");
            } else {
                httpResponse.sendError(errCode, authenticationEx.getMessage());
            }
        }
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOGGER.trace("SPNEGO starting for url: {}", (Object)request.getRequestURL());
            } else {
                LOGGER.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            authorization = authorization.substring("Negotiate".length()).trim();
            Base64 base64 = new Base64(0);
            byte[] clientToken = base64.decode(authorization);
            try {
                String serverPrincipal = KerberosUtil.getTokenServerName(clientToken);
                if (!serverPrincipal.startsWith("HTTP/")) {
                    throw new IllegalArgumentException("Invalid server principal " + serverPrincipal + "decoded from client request");
                }
                token = Subject.doAs(this.serverSubject, () -> this.runWithPrincipal(serverPrincipal, clientToken, base64, response));
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw new AuthenticationException((Throwable)ex.getException());
            }
            catch (Exception ex) {
                throw new AuthenticationException((Throwable)ex);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationToken runWithPrincipal(String serverPrincipal, byte[] clientToken, Base64 base64, HttpServletResponse response) throws IOException, GSSException {
        GSSContext gssContext = null;
        GSSCredential gssCreds = null;
        AuthenticationToken token = null;
        try {
            LOGGER.trace("SPNEGO initiated with server principal [{}]", (Object)serverPrincipal);
            gssCreds = this.gssManager.createCredential(this.gssManager.createName(serverPrincipal, KerberosUtil.NT_GSS_KRB5_PRINCIPAL_OID), Integer.MAX_VALUE, new Oid[]{KerberosUtil.GSS_SPNEGO_MECH_OID, KerberosUtil.GSS_KRB5_MECH_OID}, 2);
            gssContext = this.gssManager.createContext(gssCreds);
            byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
            if (serverToken != null && serverToken.length > 0) {
                String authenticate = base64.encodeToString(serverToken);
                response.setHeader("WWW-Authenticate", "Negotiate " + authenticate);
            }
            if (!gssContext.isEstablished()) {
                response.setStatus(401);
                LOGGER.trace("SPNEGO in progress");
            } else {
                String clientPrincipal = gssContext.getSrcName().toString();
                KerberosName kerberosName = new KerberosName(clientPrincipal);
                String userName = kerberosName.getShortName();
                token = new AuthenticationToken(userName, clientPrincipal, TYPE);
                response.setStatus(200);
                LOGGER.trace("SPNEGO completed for client principal [{}]", (Object)clientPrincipal);
            }
        }
        finally {
            if (gssContext != null) {
                gssContext.dispose();
            }
            if (gssCreds != null) {
                gssCreds.dispose();
            }
        }
        return token;
    }

    protected String getRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        if (request.getQueryString() != null) {
            sb.append("?").append(request.getQueryString());
        }
        return sb.toString();
    }

    private AuthenticationToken getToken(HttpServletRequest request) throws AuthenticationException {
        javax.servlet.http.Cookie[] cookies = request.getCookies();
        AuthenticationToken token = KerberosRealm.getTokenFromCookies(cookies);
        return token;
    }

    private static AuthenticationToken getTokenFromCookies(javax.servlet.http.Cookie[] cookies) throws AuthenticationException {
        AuthenticationToken token = null;
        String tokenStr = null;
        if (cookies != null) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                if (!cookie.getName().equals("hadoop.auth")) continue;
                tokenStr = cookie.getValue();
                if (tokenStr.isEmpty()) {
                    throw new AuthenticationException("Empty token");
                }
                try {
                    tokenStr = signer.verifyAndExtract(tokenStr);
                    break;
                }
                catch (SignerException ex) {
                    throw new AuthenticationException((Throwable)ex);
                }
            }
        }
        if (tokenStr != null) {
            token = AuthenticationToken.parse(tokenStr);
            boolean match = KerberosRealm.verifyTokenType(token);
            if (!match) {
                throw new AuthenticationException("Invalid AuthenticationToken type");
            }
            if (token.isExpired()) {
                throw new AuthenticationException("AuthenticationToken expired");
            }
        }
        return token;
    }

    public static KerberosToken getKerberosTokenFromCookies(Map<String, Cookie> cookies) throws org.apache.shiro.authc.AuthenticationException {
        KerberosToken kerberosToken = null;
        String tokenStr = null;
        if (cookies != null) {
            for (Cookie cookie : cookies.values()) {
                if (!cookie.getName().equals("Authorization")) continue;
                tokenStr = cookie.getValue();
                if (tokenStr.isEmpty()) {
                    throw new org.apache.shiro.authc.AuthenticationException("Empty token");
                }
                try {
                    tokenStr = tokenStr.substring("Negotiate".length()).trim();
                    break;
                }
                catch (Exception ex) {
                    throw new org.apache.shiro.authc.AuthenticationException((Throwable)ex);
                }
            }
        }
        if (tokenStr != null) {
            try {
                AuthenticationToken authToken = AuthenticationToken.parse(tokenStr);
                boolean match = KerberosRealm.verifyTokenType(authToken);
                if (!match) {
                    throw new org.apache.shiro.authc.AuthenticationException("Invalid AuthenticationToken type");
                }
                if (authToken.isExpired()) {
                    throw new org.apache.shiro.authc.AuthenticationException("AuthenticationToken expired");
                }
                kerberosToken = new KerberosToken(authToken.getUserName(), tokenStr);
            }
            catch (AuthenticationException ex) {
                throw new org.apache.shiro.authc.AuthenticationException((Throwable)ex);
            }
        }
        return kerberosToken;
    }

    protected static boolean verifyTokenType(AuthenticationToken token) {
        return TYPE.equals(token.getType());
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static void createAuthCookie(HttpServletResponse resp, String token, String domain, String path, long expires, boolean isCookiePersistent, boolean isSecure) {
        StringBuilder sb = new StringBuilder("hadoop.auth").append("=");
        if (token != null && token.length() > 0) {
            sb.append("\"").append(token).append("\"");
        }
        if (path != null) {
            sb.append("; Path=").append(path);
        }
        if (domain != null) {
            sb.append("; Domain=").append(domain);
        }
        if (expires >= 0L && isCookiePersistent) {
            Date date = new Date(expires);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; Expires=").append(df.format(date));
        }
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        resp.addHeader("Set-Cookie", sb.toString());
    }

    protected Properties getConfiguration() {
        Properties props = new Properties();
        props.put(COOKIE_DOMAIN, this.cookieDomain);
        props.put(COOKIE_PATH, this.cookiePath);
        props.put(COOKIE_PERSISTENT, (Object)this.isCookiePersistent);
        props.put(SIGNER_SECRET_PROVIDER, this.signatureSecretProvider);
        props.put(SIGNATURE_SECRET_FILE, this.signatureSecretFile);
        props.put(AUTH_TYPE, TYPE);
        props.put(AUTH_TOKEN_VALIDITY, (Object)this.tokenValidity);
        props.put(AUTH_TOKEN_MAX_INACTIVE_INTERVAL, (Object)this.tokenMaxInactiveInterval);
        props.put(PRINCIPAL, this.principal);
        props.put(KEYTAB, this.keytab);
        props.put(NAME_RULES, this.nameRules);
        props.put(LOGOUT, this.logout);
        return props;
    }

    protected long getTokenMaxInactiveInterval() {
        return this.tokenMaxInactiveInterval / 1000L;
    }

    protected long getTokenValidity() {
        return this.tokenValidity / 1000L;
    }

    protected String getCookieDomain() {
        return this.cookieDomain;
    }

    protected String getCookiePath() {
        return this.cookiePath;
    }

    public boolean isCookiePersistent() {
        return this.isCookiePersistent;
    }

    public void setTokenMaxInactiveInterval(long tokenMaxInactiveInterval) {
        this.tokenMaxInactiveInterval = tokenMaxInactiveInterval * 1000L;
    }

    public void setTokenValidity(long tokenValidity) {
        this.tokenValidity = tokenValidity * 1000L;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookiePersistent(boolean cookiePersistent) {
        this.isCookiePersistent = cookiePersistent;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setKeytab(String keytab) {
        this.keytab = keytab;
    }

    public String getNameRules() {
        return this.nameRules;
    }

    public void setNameRules(String nameRules) {
        this.nameRules = nameRules;
    }

    public String getSignatureSecretFile() {
        return this.signatureSecretFile;
    }

    public void setSignatureSecretFile(String signatureSecretFile) {
        this.signatureSecretFile = signatureSecretFile;
    }

    public String getSignatureSecretProvider() {
        return this.signatureSecretProvider;
    }

    public void setSignatureSecretProvider(String signatureSecretProvider) {
        this.signatureSecretProvider = signatureSecretProvider;
    }

    public String getLogout() {
        return this.logout;
    }

    public void setLogout(String logout) {
        this.logout = logout;
    }

    public Boolean getLogoutAPI() {
        return this.logoutAPI;
    }

    public void setLogoutAPI(Boolean logoutAPI) {
        this.logoutAPI = logoutAPI;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getRedirectParam() {
        return this.redirectParam;
    }

    public void setRedirectParam(String redirectParam) {
        this.redirectParam = redirectParam;
    }

    public void destroy() {
        this.keytab = null;
        this.serverSubject = null;
        if (this.secretProvider != null && this.destroySecretProvider) {
            this.secretProvider.destroy();
            this.secretProvider = null;
        }
    }
}

