/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.realm.jwt.JWTAuthenticationToken;
import org.apache.zeppelin.realm.jwt.KnoxJwtRealm;
import org.apache.zeppelin.realm.kerberos.KerberosRealm;
import org.apache.zeppelin.realm.kerberos.KerberosToken;
import org.apache.zeppelin.rest.AbstractRestApi;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.ticket.TicketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/login")
@Produces(value={"application/json"})
@Singleton
public class LoginRestApi
extends AbstractRestApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginRestApi.class);
    private final ZeppelinConfiguration zConf;
    private final AuthorizationService authorizationService;

    @Inject
    public LoginRestApi(ZeppelinConfiguration zConf, AuthenticationService authenticationService, AuthorizationService authorizationService) {
        super(authenticationService);
        this.zConf = zConf;
        this.authorizationService = authorizationService;
    }

    @GET
    @ZeppelinApi
    public Response getLogin(@Context HttpHeaders headers) {
        JsonResponse<Object> response = null;
        if (this.isKnoxSSOEnabled()) {
            KnoxJwtRealm knoxJwtRealm = this.getJTWRealm();
            Cookie cookie = (Cookie)headers.getCookies().get(knoxJwtRealm.getCookieName());
            if (cookie != null && cookie.getValue() != null) {
                Subject currentUser = SecurityUtils.getSubject();
                JWTAuthenticationToken token = new JWTAuthenticationToken(null, cookie.getValue());
                try {
                    String name = knoxJwtRealm.getName(token);
                    if (!currentUser.isAuthenticated() || !currentUser.getPrincipal().equals(name)) {
                        response = this.proceedToLogin(currentUser, token);
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("ParseException in LoginRestApi: ", (Throwable)e);
                }
            }
            if (response == null) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("redirectURL", this.constructUrl(knoxJwtRealm.getProviderUrl(), knoxJwtRealm.getRedirectParam(), knoxJwtRealm.getLogin()));
                response = new JsonResponse(Response.Status.OK, "", data);
            }
            return response.build();
        }
        KerberosRealm kerberosRealm = this.getKerberosRealm();
        if (null != kerberosRealm) {
            try {
                Map cookies = headers.getCookies();
                KerberosToken kerberosToken = KerberosRealm.getKerberosTokenFromCookies(cookies);
                if (null != kerberosToken) {
                    Subject currentUser = SecurityUtils.getSubject();
                    String name = (String)kerberosToken.getPrincipal();
                    if (!currentUser.isAuthenticated() || !currentUser.getPrincipal().equals(name)) {
                        response = this.proceedToLogin(currentUser, kerberosToken);
                    }
                }
                if (null == response) {
                    LOGGER.warn("No Kerberos token received");
                    response = new JsonResponse<Object>(Response.Status.UNAUTHORIZED, "", null);
                }
                return response.build();
            }
            catch (AuthenticationException e) {
                LOGGER.error("Error in Login", (Throwable)e);
            }
        }
        return new JsonResponse(Response.Status.METHOD_NOT_ALLOWED).build();
    }

    private KerberosRealm getKerberosRealm() {
        Collection<Realm> realmsList = this.authenticationService.getRealmsList();
        if (realmsList != null) {
            for (Realm realm : realmsList) {
                String name = realm.getClass().getName();
                LOGGER.debug("RealmClass.getName: {}", (Object)name);
                if (!name.equals("org.apache.zeppelin.realm.kerberos.KerberosRealm")) continue;
                return (KerberosRealm)realm;
            }
        }
        return null;
    }

    private KnoxJwtRealm getJTWRealm() {
        Collection<Realm> realmsList = this.authenticationService.getRealmsList();
        if (realmsList != null) {
            for (Realm realm : realmsList) {
                if (!(realm instanceof KnoxJwtRealm)) continue;
                return (KnoxJwtRealm)realm;
            }
        }
        return null;
    }

    private boolean isKnoxSSOEnabled() {
        Collection<Realm> realmsList = this.authenticationService.getRealmsList();
        if (realmsList != null) {
            for (Realm realm : realmsList) {
                if (!(realm instanceof KnoxJwtRealm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isKerberosRealmEnabled() {
        Collection<Realm> realmsList = this.authenticationService.getRealmsList();
        if (realmsList != null) {
            for (Realm realm : realmsList) {
                if (!(realm instanceof KerberosRealm)) continue;
                return true;
            }
        }
        return false;
    }

    private JsonResponse<Map<String, String>> proceedToLogin(Subject currentUser, AuthenticationToken token) {
        JsonResponse response = null;
        try {
            this.logoutCurrentUser();
            currentUser.getSession(true);
            currentUser.login(token);
            Set<String> roles = this.authenticationService.getAssociatedRoles();
            String principal = this.authenticationService.getPrincipal();
            TicketContainer.Entry ticketEntry = "anonymous".equals(principal) ? TicketContainer.ANONYMOUS_ENTRY : TicketContainer.instance.getTicketEntry(principal, roles);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("principal", ticketEntry.getPrincipal());
            data.put("roles", GSON.toJson((Object)ticketEntry.getRoles()));
            data.put("ticket", ticketEntry.getTicket());
            response = new JsonResponse(Response.Status.OK, "", data);
            this.authorizationService.setRoles(principal, roles);
        }
        catch (AuthenticationException uae) {
            LOGGER.error("Exception in login: ", (Throwable)uae);
        }
        return response;
    }

    @POST
    @ZeppelinApi
    public Response postLogin(@FormParam(value="userName") String userName, @FormParam(value="password") String password) {
        LOGGER.debug("userName: {}", (Object)userName);
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            currentUser.logout();
        }
        LOGGER.debug("currentUser: {}", (Object)currentUser);
        JsonResponse<Object> response = null;
        if (!currentUser.isAuthenticated()) {
            UsernamePasswordToken token = new UsernamePasswordToken(userName, password);
            response = this.proceedToLogin(currentUser, (AuthenticationToken)token);
        }
        if (response == null) {
            response = new JsonResponse<Object>(Response.Status.FORBIDDEN, "", null);
        }
        LOGGER.info(response.toString());
        return response.build();
    }

    @POST
    @Path(value="logout")
    @ZeppelinApi
    public Response logout() {
        Response.Status status;
        this.logoutCurrentUser();
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.zConf.isAuthorizationHeaderClear()) {
            status = Response.Status.UNAUTHORIZED;
            data.put("clearAuthorizationHeader", "true");
        } else {
            status = Response.Status.FORBIDDEN;
            data.put("clearAuthorizationHeader", "false");
        }
        if (this.isKnoxSSOEnabled()) {
            KnoxJwtRealm knoxJwtRealm = this.getJTWRealm();
            data.put("redirectURL", this.constructUrl(knoxJwtRealm.getProviderUrl(), knoxJwtRealm.getRedirectParam(), knoxJwtRealm.getLogout()));
            data.put("isLogoutAPI", knoxJwtRealm.getLogoutAPI().toString());
        } else if (this.isKerberosRealmEnabled()) {
            KerberosRealm kerberosRealm = this.getKerberosRealm();
            data.put("redirectURL", this.constructUrl(kerberosRealm.getProviderUrl(), kerberosRealm.getRedirectParam(), kerberosRealm.getLogout()));
            data.put("isLogoutAPI", kerberosRealm.getLogoutAPI().toString());
        }
        JsonResponse response = new JsonResponse(status, "", data);
        LOGGER.info(response.toString());
        return response.build();
    }

    private String constructUrl(String providerURL, String redirectParam, String path) {
        StringBuilder redirectURL = new StringBuilder(providerURL);
        redirectURL.append(path);
        if (redirectParam != null) {
            redirectURL.append("?").append(redirectParam).append("=");
        }
        return redirectURL.toString();
    }

    private void logoutCurrentUser() {
        Subject currentUser = SecurityUtils.getSubject();
        TicketContainer.instance.removeTicket(this.authenticationService.getPrincipal());
        currentUser.getSession().stop();
        currentUser.logout();
    }
}

