/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.utils;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;

public class CorsUtils {
    public static final String HEADER_ORIGIN = "Origin";

    private CorsUtils() {
    }

    public static boolean isValidOrigin(String sourceHost, ZeppelinConfiguration zConf) throws UnknownHostException, URISyntaxException {
        String sourceUriHost = "";
        if (sourceHost != null && !sourceHost.isEmpty()) {
            sourceUriHost = new URI(sourceHost).getHost();
            sourceUriHost = sourceUriHost == null ? "" : sourceUriHost.toLowerCase();
        }
        sourceUriHost = sourceUriHost.toLowerCase();
        String currentHost = InetAddress.getLocalHost().getHostName().toLowerCase();
        return zConf.getAllowedOrigins().contains("*") || currentHost.equals(sourceUriHost) || "localhost".equals(sourceUriHost) || zConf.getAllowedOrigins().contains(sourceHost);
    }
}

