/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.ProgressMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.DockerSpecTemplate;
import org.apache.zeppelin.interpreter.launcher.utils.TarFileEntry;
import org.apache.zeppelin.interpreter.launcher.utils.TarUtils;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInterpreterProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerInterpreterProcess.class);
    private String dockerIntpServicePort = "0";
    private final String interpreterGroupId;
    private final String interpreterGroupName;
    private final String interpreterSettingName;
    private final String containerImage;
    private final Properties properties;
    private final Map<String, String> envs;
    private AtomicBoolean dockerStarted = new AtomicBoolean(false);
    private DockerClient docker = null;
    private final String containerName;
    private String containerHost = "";
    private int containerPort = 0;
    private static final String DOCKER_INTP_JINJA = "/jinja_templates/docker-interpreter.jinja";
    @VisibleForTesting
    boolean uploadLocalLibToContainter = true;
    private ZeppelinConfiguration zConf;
    private String zeppelinHome;
    private final String containerZeppelinHome;
    @VisibleForTesting
    final String containerSparkHome;
    @VisibleForTesting
    final String dockerHost;
    private static final String CONTAINER_UPLOAD_TAR_DIR = "/tmp/zeppelin-tar";

    public DockerInterpreterProcess(ZeppelinConfiguration zConf, String containerImage, String interpreterGroupId, String interpreterGroupName, String interpreterSettingName, Properties properties, Map<String, String> envs, String intpEventServerHost, int intpEventServerPort, int connectTimeout, int connectionPoolSize) {
        super(connectTimeout, connectionPoolSize, intpEventServerHost, intpEventServerPort);
        this.containerImage = containerImage;
        this.interpreterGroupId = interpreterGroupId;
        this.interpreterGroupName = interpreterGroupName;
        this.interpreterSettingName = interpreterSettingName;
        this.properties = properties;
        this.envs = new HashMap<String, String>(envs);
        this.zConf = zConf;
        this.containerName = interpreterGroupId.toLowerCase();
        this.containerZeppelinHome = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_DOCKER_CONTAINER_HOME);
        this.containerSparkHome = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_DOCKER_CONTAINER_SPARK_HOME);
        this.uploadLocalLibToContainter = zConf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_DOCKER_UPLOAD_LOCAL_LIB_TO_CONTAINTER);
        try {
            this.zeppelinHome = this.getZeppelinHome();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.dockerHost = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_DOCKER_HOST);
    }

    public String getInterpreterGroupId() {
        return this.interpreterGroupId;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String userName) throws IOException {
        String[] ports;
        this.docker = DefaultDockerClient.builder().uri(URI.create(this.dockerHost)).build();
        this.removeExistContainer(this.containerName);
        HashMap portBindings = new HashMap();
        int intpServicePort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
        this.dockerIntpServicePort = String.valueOf(intpServicePort);
        for (String port : ports = new String[]{this.dockerIntpServicePort}) {
            ArrayList<PortBinding> hostPorts = new ArrayList<PortBinding>();
            hostPorts.add(PortBinding.of((String)"0.0.0.0", (String)port));
            portBindings.put(port, hostPorts);
        }
        HostConfig hostConfig = HostConfig.builder().networkMode("host").portBindings(portBindings).build();
        DockerSpecTemplate specTemplate = new DockerSpecTemplate();
        specTemplate.loadProperties(this.getTemplateBindings());
        URL urlTemplate = ((Object)((Object)this)).getClass().getResource(DOCKER_INTP_JINJA);
        String template = Resources.toString((URL)urlTemplate, (Charset)StandardCharsets.UTF_8);
        String dockerCommand = specTemplate.render(template);
        int firstLineIsNewline = dockerCommand.indexOf("\n");
        if (firstLineIsNewline == 0) {
            dockerCommand = dockerCommand.replaceFirst("\n", "");
        }
        LOGGER.info("dockerCommand = {}", (Object)dockerCommand);
        List<String> listEnv = this.getListEnvs();
        LOGGER.info("docker listEnv = {}", listEnv);
        StringBuilder sbStartCmd = new StringBuilder();
        sbStartCmd.append("sleep 20; ");
        sbStartCmd.append("process=RemoteInterpreterServer; ");
        sbStartCmd.append("RUNNING_PIDS=$(ps x | grep $process | grep -v grep | awk '{print $1}'); ");
        sbStartCmd.append("while [ ! -z \"$RUNNING_PIDS\" ]; ");
        sbStartCmd.append("do sleep 1; ");
        sbStartCmd.append("RUNNING_PIDS=$(ps x | grep $process | grep -v grep | awk '{print $1}'); ");
        sbStartCmd.append("done");
        ContainerConfig containerConfig = ContainerConfig.builder().hostConfig(hostConfig).hostname(this.intpEventServerHost).image(this.containerImage).workingDir("/").env(listEnv).cmd(new String[]{"sh", "-c", sbStartCmd.toString()}).build();
        try {
            LOGGER.info("wait docker pull image {} ...", (Object)this.containerImage);
            this.docker.pull(this.containerImage, new ProgressHandler(){

                public void progress(ProgressMessage message) throws DockerException {
                    if (null != message.error()) {
                        LOGGER.error(message.toString());
                    }
                }
            });
            ContainerCreation containerCreation = this.docker.createContainer(containerConfig, this.containerName);
            String containerId = containerCreation.id();
            this.docker.startContainer(containerId);
            this.copyRunFileToContainer(containerId);
            this.execInContainer(containerId, dockerCommand, false);
        }
        catch (DockerException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Docker preparations were interrupted.", e);
        }
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + (long)this.getConnectTimeout();
        AtomicBoolean atomicBoolean = this.dockerStarted;
        synchronized (atomicBoolean) {
            LOGGER.info("Waiting for interpreter container to be ready");
            while (!this.dockerStarted.get() && !Thread.currentThread().isInterrupted()) {
                long timeToTimeout = timeoutTime - System.currentTimeMillis();
                if (timeToTimeout <= 0L) {
                    LOGGER.info("Interpreter docker creation is time out in {} seconds", (Object)(this.getConnectTimeout() / 1000));
                    this.stop();
                    throw new IOException("Launching zeppelin interpreter on docker is time out, kill it now");
                }
                try {
                    this.dockerStarted.wait(timeToTimeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.stop();
                    throw new IOException("Remote interpreter is not accessible", e);
                }
            }
        }
        while (System.currentTimeMillis() - startTime < (long)this.getConnectTimeout() && !RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(int port, String host) {
        this.containerHost = host;
        this.containerPort = port;
        LOGGER.info("Interpreter container created {}:{}", (Object)this.containerHost, (Object)this.containerPort);
        AtomicBoolean atomicBoolean = this.dockerStarted;
        synchronized (atomicBoolean) {
            this.dockerStarted.set(true);
            this.dockerStarted.notifyAll();
        }
    }

    @VisibleForTesting
    Properties getTemplateBindings() {
        Properties dockerProperties = new Properties();
        dockerProperties.put("CONTAINER_ZEPPELIN_HOME", this.containerZeppelinHome);
        dockerProperties.put("zeppelin.interpreter.container.image", this.containerImage);
        dockerProperties.put("zeppelin.interpreter.group.id", this.interpreterGroupId);
        dockerProperties.put("zeppelin.interpreter.group.name", this.interpreterGroupName);
        dockerProperties.put("zeppelin.interpreter.setting.name", this.interpreterSettingName);
        dockerProperties.put("zeppelin.interpreter.localRepo", "/tmp/local-repo");
        dockerProperties.put("zeppelin.interpreter.rpc.portRange", this.dockerIntpServicePort + ":" + this.dockerIntpServicePort);
        dockerProperties.put("zeppelin.server.rpc.host", this.intpEventServerHost);
        dockerProperties.put("zeppelin.server.rpc.portRange", (Object)this.intpEventServerPort);
        dockerProperties.putAll((Map<?, ?>)Maps.fromProperties((Properties)this.properties));
        return dockerProperties;
    }

    @VisibleForTesting
    List<String> getListEnvs() {
        this.envs.put("ZEPPELIN_HOME", this.containerZeppelinHome);
        this.envs.put("ZEPPELIN_CONF_DIR", this.containerZeppelinHome + "/conf");
        this.envs.put("ZEPPELIN_FORCE_STOP", "true");
        this.envs.put("SPARK_HOME", this.containerSparkHome);
        this.envs.remove("JAVA_HOME");
        this.envs.remove("PATH");
        this.envs.put("TZ", this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_DOCKER_TIME_ZONE));
        ArrayList<String> listEnv = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.envs.entrySet()) {
            String env = entry.getKey() + "=" + entry.getValue();
            listEnv.add(env);
        }
        return listEnv;
    }

    public void stop() {
        if (this.isRunning()) {
            LOGGER.info("Kill interpreter process");
            try {
                this.callRemoteFunction(client -> {
                    client.shutdown();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("Ignore the exception when shutting down", (Throwable)e);
            }
        }
        try {
            this.docker.killContainer(this.containerName);
            this.docker.removeContainer(this.containerName);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (DockerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.docker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExistContainer(String containerName) {
        boolean isExist = false;
        try {
            List containers = this.docker.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers()});
            block19: for (Container container : containers) {
                for (String name : container.names()) {
                    if (!StringUtils.equals((String)name, (String)("/" + containerName))) continue;
                    isExist = true;
                    continue block19;
                }
            }
            if (isExist) {
                LOGGER.info("kill exist container {}", (Object)containerName);
                this.docker.killContainer(containerName);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (DockerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (isExist) {
                    this.docker.removeContainer(containerName);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (DockerException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getHost() {
        return this.containerHost;
    }

    public int getPort() {
        return this.containerPort;
    }

    public boolean isAlive() {
        return this.isRunning();
    }

    public boolean isRunning() {
        return RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort());
    }

    public String getErrorMessage() {
        return null;
    }

    private void copyRunFileToContainer(String containerId) throws IOException, DockerException, InterruptedException {
        String zeppelinServerKeytab;
        HashMap<String, String> copyFiles = new HashMap<String, String>();
        this.rmInContainer(containerId, this.containerZeppelinHome);
        this.mkdirInContainer(containerId, this.containerZeppelinHome);
        String confPath = "/conf";
        String zeplConfPath = this.getPathByHome(this.zeppelinHome, confPath);
        this.mkdirInContainer(containerId, this.containerZeppelinHome);
        String containerZeplConfPath = this.containerZeppelinHome + confPath;
        copyFiles.put(zeplConfPath + "/zeppelin-site.xml", containerZeplConfPath + "/zeppelin-site.xml");
        copyFiles.put(zeplConfPath + "/log4j.properties", containerZeplConfPath + "/log4j.properties");
        copyFiles.put(zeplConfPath + "/log4j_yarn_cluster.properties", containerZeplConfPath + "/log4j_yarn_cluster.properties");
        String krb5conf = "/etc/krb5.conf";
        File krb5File = new File(krb5conf);
        if (krb5File.exists()) {
            this.rmInContainer(containerId, krb5conf);
            copyFiles.put(krb5conf, krb5conf);
        } else {
            LOGGER.warn("{} file not found, Did not upload the krb5.conf to the container!", (Object)krb5conf);
        }
        String intpKeytab = this.properties.getProperty("zeppelin.shell.keytab.location", "");
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("spark.yarn.keytab", "");
        }
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("zeppelin.livy.keytab", "");
        }
        if (StringUtils.isBlank((String)intpKeytab)) {
            intpKeytab = this.properties.getProperty("zeppelin.jdbc.keytab.location", "");
        }
        if (!StringUtils.isBlank((String)intpKeytab)) {
            LOGGER.info("intpKeytab : {}", (Object)intpKeytab);
            copyFiles.putIfAbsent(intpKeytab, intpKeytab);
        }
        if (!StringUtils.isBlank((String)(zeppelinServerKeytab = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_KEYTAB)))) {
            copyFiles.putIfAbsent(zeppelinServerKeytab, zeppelinServerKeytab);
        }
        if (this.envs.containsKey("HADOOP_CONF_DIR")) {
            String hadoopConfDir = this.envs.get("HADOOP_CONF_DIR");
            copyFiles.put(hadoopConfDir, hadoopConfDir);
        }
        if (this.envs.containsKey("SPARK_CONF_DIR")) {
            String sparkConfDir = this.envs.get("SPARK_CONF_DIR");
            this.rmInContainer(containerId, this.containerSparkHome + "/conf");
            this.mkdirInContainer(containerId, this.containerSparkHome + "/conf");
            copyFiles.put(sparkConfDir, this.containerSparkHome + "/conf");
            this.envs.put("SPARK_CONF_DIR", this.containerSparkHome + "/conf");
        }
        if (this.uploadLocalLibToContainter) {
            String binPath = "/bin";
            String zeplBinPath = this.getPathByHome(this.zeppelinHome, binPath);
            String containerZeplBinPath = this.containerZeppelinHome + binPath;
            this.mkdirInContainer(containerId, containerZeplBinPath);
            this.docker.copyToContainer(new File(zeplBinPath).toPath(), containerId, containerZeplBinPath);
            String intpGrpPath = "/interpreter/" + this.interpreterGroupName;
            String intpGrpAllPath = this.getPathByHome(this.zeppelinHome, intpGrpPath);
            String containerIntpGrpPath = this.containerZeppelinHome + intpGrpPath;
            this.mkdirInContainer(containerId, containerIntpGrpPath);
            this.docker.copyToContainer(new File(intpGrpAllPath).toPath(), containerId, containerIntpGrpPath);
            String intpPath = "/interpreter";
            String intpAllPath = this.getPathByHome(this.zeppelinHome, intpPath);
            String containerIntpAllPath = this.containerZeppelinHome + intpPath;
            Collection listFiles = FileUtils.listFiles((File)new File(intpAllPath), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)"jar"), null);
            for (File jarfile : listFiles) {
                String jarfilePath = jarfile.getAbsolutePath();
                String jarfileName = jarfile.getName();
                String containerJarfilePath = containerIntpAllPath + "/" + jarfileName;
                if (StringUtils.isBlank((String)jarfilePath)) continue;
                copyFiles.putIfAbsent(jarfilePath, containerJarfilePath);
            }
        }
        this.deployToContainer(containerId, copyFiles);
    }

    private void deployToContainer(String containerId, HashMap<String, String> copyFiles) throws InterruptedException, DockerException, IOException {
        this.mkdirInContainer(containerId, CONTAINER_UPLOAD_TAR_DIR);
        String tarFile = this.file2Tar(copyFiles);
        try (FileInputStream inputStream = new FileInputStream(tarFile);){
            this.docker.copyToContainer((InputStream)inputStream, containerId, CONTAINER_UPLOAD_TAR_DIR);
        }
        this.cpdirInContainer(containerId, "/tmp/zeppelin-tar/*", "/");
        Files.delete(Paths.get(tarFile, new String[0]));
    }

    private void mkdirInContainer(String containerId, String path) throws DockerException, InterruptedException {
        String execCommand = "mkdir " + path + " -p";
        this.execInContainer(containerId, execCommand, true);
    }

    private void rmInContainer(String containerId, String path) throws DockerException, InterruptedException {
        String execCommand = "rm " + path + " -R";
        this.execInContainer(containerId, execCommand, true);
    }

    private void cpdirInContainer(String containerId, String from, String to) throws DockerException, InterruptedException {
        String execCommand = "cp " + from + " " + to + " -R";
        this.execInContainer(containerId, execCommand, true);
    }

    private void execInContainer(String containerId, String execCommand, boolean logout) throws DockerException, InterruptedException {
        LOGGER.info("exec container commmand: {}", (Object)execCommand);
        String[] command = new String[]{"sh", "-c", execCommand};
        ExecCreation execCreation = this.docker.execCreate(containerId, command, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr()});
        LogStream logStream = this.docker.execStart(execCreation.id(), new DockerClient.ExecStartParameter[0]);
        while (logStream.hasNext() && logout) {
            String log = StandardCharsets.UTF_8.decode(((LogMessage)logStream.next()).content()).toString();
            LOGGER.info(log);
        }
    }

    private String file2Tar(HashMap<String, String> copyFiles) throws IOException {
        File tmpDir = Files.createTempDirectory("file2Tar", new FileAttribute[0]).toFile();
        Date date = new Date();
        String tarFileName = tmpDir.getPath() + date.getTime() + ".tar";
        ArrayList<TarFileEntry> tarFileEntries = new ArrayList<TarFileEntry>();
        for (Map.Entry<String, String> entry : copyFiles.entrySet()) {
            String filePath = entry.getKey();
            String archivePath = entry.getValue();
            TarFileEntry tarFileEntry = new TarFileEntry(new File(filePath), archivePath);
            tarFileEntries.add(tarFileEntry);
        }
        TarUtils.compress(tarFileName, tarFileEntries);
        return tarFileName;
    }

    @VisibleForTesting
    boolean isSpark() {
        return "spark".equalsIgnoreCase(this.interpreterGroupName);
    }

    private String getZeppelinHome() throws IOException {
        File fileZeppelinHome = new File(this.zConf.getZeppelinHome());
        if (fileZeppelinHome.exists() && fileZeppelinHome.isDirectory()) {
            return this.zConf.getZeppelinHome();
        }
        throw new IOException("Can't find zeppelin home path!");
    }

    private String getPathByHome(String homeDir, String path) throws IOException {
        File file = null;
        file = null == homeDir || StringUtils.isEmpty((String)homeDir) ? new File(path) : new File(homeDir, path);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new IOException("Can't find directory in " + homeDir + path + "!");
    }
}

