/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.zeppelin.interpreter.InterpreterException;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class CqlFormatter$ {
    public static CqlFormatter$ MODULE$;
    private final String DEFAULT_TIMEZONE;
    private final String DEFAULT_FORMAT;
    private final int DEFAULT_FLOAT_PRECISION;
    private final int DEFAULT_DOUBLE_PRECISION;
    private final int DEFAULT_DECIMAL_PRECISION;
    private final String DEFAULT_TIMESTAMP_FORMAT;
    private final String DEFAULT_TIME_FORMAT;
    private final String DEFAULT_DATE_FORMAT;
    private final String DEFAULT_LOCALE;
    private final Set<String> allAvailableTimezones;

    static {
        new CqlFormatter$();
    }

    public String $lessinit$greater$default$1() {
        return this.DEFAULT_FORMAT();
    }

    public int $lessinit$greater$default$2() {
        return this.DEFAULT_FLOAT_PRECISION();
    }

    public int $lessinit$greater$default$3() {
        return this.DEFAULT_DOUBLE_PRECISION();
    }

    public int $lessinit$greater$default$4() {
        return this.DEFAULT_DECIMAL_PRECISION();
    }

    public String $lessinit$greater$default$5() {
        return this.DEFAULT_TIMESTAMP_FORMAT();
    }

    public String $lessinit$greater$default$6() {
        return this.DEFAULT_TIME_FORMAT();
    }

    public String $lessinit$greater$default$7() {
        return this.DEFAULT_DATE_FORMAT();
    }

    public String $lessinit$greater$default$8() {
        return this.DEFAULT_TIMEZONE();
    }

    public String $lessinit$greater$default$9() {
        return this.DEFAULT_LOCALE();
    }

    public String DEFAULT_TIMEZONE() {
        return this.DEFAULT_TIMEZONE;
    }

    public String DEFAULT_FORMAT() {
        return this.DEFAULT_FORMAT;
    }

    public int DEFAULT_FLOAT_PRECISION() {
        return this.DEFAULT_FLOAT_PRECISION;
    }

    public int DEFAULT_DOUBLE_PRECISION() {
        return this.DEFAULT_DOUBLE_PRECISION;
    }

    public int DEFAULT_DECIMAL_PRECISION() {
        return this.DEFAULT_DECIMAL_PRECISION;
    }

    public String DEFAULT_TIMESTAMP_FORMAT() {
        return this.DEFAULT_TIMESTAMP_FORMAT;
    }

    public String DEFAULT_TIME_FORMAT() {
        return this.DEFAULT_TIME_FORMAT;
    }

    public String DEFAULT_DATE_FORMAT() {
        return this.DEFAULT_DATE_FORMAT;
    }

    public String DEFAULT_LOCALE() {
        return this.DEFAULT_LOCALE;
    }

    public Set<String> allAvailableTimezones() {
        return this.allAvailableTimezones;
    }

    public Option<DecimalFormat> getNumberFormatter(Locale locale, int precision) {
        if (precision == -1) {
            return None$.MODULE$;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        df.applyPattern(new StringBuilder(2).append("#.").append(new StringOps(Predef$.MODULE$.augmentString("#")).$times(precision)).toString());
        return new Some<DecimalFormat>(df);
    }

    public DateTimeFormatter getDateTimeFormatter(Locale locale, ZoneId timeZone, String format) {
        DateTimeFormatter dateTimeFormatter;
        try {
            dateTimeFormatter = DateTimeFormatter.ofPattern(format).withLocale(locale).withZone(timeZone);
        }
        catch (IllegalArgumentException ex) {
            throw new InterpreterException(new StringBuilder(45).append("Invalid time/date format: '").append(format).append("'. error message: ").append(ex.getMessage()).toString());
        }
        return dateTimeFormatter;
    }

    public Locale getLocale(String localeStr) {
        Locale locale;
        try {
            locale = LocaleUtils.toLocale(localeStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InterpreterException(new StringBuilder(18).append("Invalid locale: '").append(localeStr).append("'").toString());
        }
        return locale;
    }

    public ZoneId getTimezone(String tzStr) {
        if (!this.allAvailableTimezones().contains(tzStr)) {
            throw new InterpreterException(new StringBuilder(20).append("Invalid timezone: '").append(tzStr).append("'").toString());
        }
        return TimeZone.getTimeZone(tzStr).toZoneId();
    }

    private CqlFormatter$() {
        MODULE$ = this;
        this.DEFAULT_TIMEZONE = "UTC";
        this.DEFAULT_FORMAT = "human";
        this.DEFAULT_FLOAT_PRECISION = 5;
        this.DEFAULT_DOUBLE_PRECISION = 12;
        this.DEFAULT_DECIMAL_PRECISION = -1;
        this.DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        this.DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
        this.DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
        this.DEFAULT_LOCALE = "en_US";
        this.allAvailableTimezones = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])TimeZone.getAvailableIDs())).toSet();
    }
}

