/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import io.netty.buffer.ByteBufUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.zeppelin.cassandra.CqlFormatter$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t-w!B-[\u0011\u0003\u0019g!B3[\u0011\u00031\u0007\"B7\u0002\t\u0003q\u0007bB8\u0002\u0005\u0004%\t\u0001\u001d\u0005\u0007s\u0006\u0001\u000b\u0011B9\t\u000fi\f!\u0019!C\u0001a\"110\u0001Q\u0001\nEDq\u0001`\u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\u0004\u0005\u0001\u000b\u0011\u0002@\t\u0011\u0005\u0015\u0011A1A\u0005\u0002uDq!a\u0002\u0002A\u0003%a\u0010\u0003\u0005\u0002\n\u0005\u0011\r\u0011\"\u0001~\u0011\u001d\tY!\u0001Q\u0001\nyD\u0001\"!\u0004\u0002\u0005\u0004%\t\u0001\u001d\u0005\b\u0003\u001f\t\u0001\u0015!\u0003r\u0011!\t\t\"\u0001b\u0001\n\u0003\u0001\bbBA\n\u0003\u0001\u0006I!\u001d\u0005\t\u0003+\t!\u0019!C\u0001a\"9\u0011qC\u0001!\u0002\u0013\t\b\u0002CA\r\u0003\t\u0007I\u0011\u00019\t\u000f\u0005m\u0011\u0001)A\u0005c\"I\u0011QD\u0001C\u0002\u0013\u0005\u0011q\u0004\u0005\t\u0003w\t\u0001\u0015!\u0003\u0002\"!9\u0011QH\u0001\u0005\u0002\u0005}\u0002bBA4\u0003\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u0017\u000bA\u0011AAG\u0011\u001d\t\u0019*\u0001C\u0001\u0003+C\u0011\"a'\u0002#\u0003%\t!!(\t\u0013\u0005M\u0016!%A\u0005\u0002\u0005U\u0006\"CA]\u0003E\u0005I\u0011AA[\u0011%\tY,AI\u0001\n\u0003\t)\fC\u0005\u0002>\u0006\t\n\u0011\"\u0001\u0002\u001e\"I\u0011qX\u0001\u0012\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003\u0003\f\u0011\u0013!C\u0001\u0003;C\u0011\"a1\u0002#\u0003%\t!!(\t\u0013\u0005\u0015\u0017!%A\u0005\u0002\u0005ue!B3[\u0001\u0005\u001d\u0007BCAeI\t\u0015\r\u0011\"\u0001\u0002L\"Q\u0011Q\u001a\u0013\u0003\u0002\u0003\u0006I!a\u000e\t\u0013\u0005=GE!b\u0001\n\u0003i\b\"CAiI\t\u0005\t\u0015!\u0003\u007f\u0011%\t\u0019\u000e\nBC\u0002\u0013\u0005Q\u0010C\u0005\u0002V\u0012\u0012\t\u0011)A\u0005}\"I\u0011q\u001b\u0013\u0003\u0006\u0004%\t! \u0005\n\u00033$#\u0011!Q\u0001\nyD!\"a7%\u0005\u000b\u0007I\u0011AAf\u0011)\ti\u000e\nB\u0001B\u0003%\u0011q\u0007\u0005\u000b\u0003?$#Q1A\u0005\u0002\u0005-\u0007BCAqI\t\u0005\t\u0015!\u0003\u00028!Q\u00111\u001d\u0013\u0003\u0006\u0004%\t!a3\t\u0015\u0005\u0015HE!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002h\u0012\u0012)\u0019!C\u0001\u0003\u0017D!\"!;%\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\t\t\n\nBC\u0002\u0013\u0005\u00111\u001a\u0005\u000b\u0003W$#\u0011!Q\u0001\n\u0005]\u0002BB7%\t\u0003\ti\u000fC\u0005\u0003\u0004\u0011\u0012\r\u0011\"\u0001\u0003\u0006!A!Q\u0002\u0013!\u0002\u0013\u00119\u0001C\u0005\u0002V\u0011\u0012\r\u0011\"\u0001\u0003\u0010!A!\u0011\u0003\u0013!\u0002\u0013\t9\u0006C\u0005\u0002\u0000\u0011\u0012\r\u0011\"\u0001\u0003\u0014!A!Q\u0003\u0013!\u0002\u0013\t\t\tC\u0005\u0003\u0018\u0011\u0012\r\u0011\"\u0001\u0003\u001a!A!1\u0004\u0013!\u0002\u0013\t\t\u0005C\u0005\u0003\u001e\u0011\u0012\r\u0011\"\u0001\u0003\u001a!A!q\u0004\u0013!\u0002\u0013\t\t\u0005C\u0005\u0003\"\u0011\u0012\r\u0011\"\u0001\u0003\u001a!A!1\u0005\u0013!\u0002\u0013\t\t\u0005C\u0005\u0003&\u0011\u0012\r\u0011\"\u0001\u0003(!A!\u0011\u0006\u0013!\u0002\u0013\tY\u0007C\u0005\u0003,\u0011\u0012\r\u0011\"\u0001\u0003(!A!Q\u0006\u0013!\u0002\u0013\tY\u0007C\u0005\u00030\u0011\u0012\r\u0011\"\u0001\u0003(!A!\u0011\u0007\u0013!\u0002\u0013\tY\u0007\u0003\u0004nI\u0011\u0005!1\u0007\u0005\b\u0005\u007f!C\u0011\u0001B!\u0011%\u0011)\u0006JI\u0001\n\u0003\ti\nC\u0005\u0003X\u0011\n\n\u0011\"\u0001\u00026\"I!\u0011\f\u0013\u0012\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u00057\"\u0013\u0013!C\u0001\u0003kC\u0011B!\u0018%#\u0003%\t!!(\t\u0013\t}C%%A\u0005\u0002\u0005u\u0005\"\u0003B1IE\u0005I\u0011AAO\u0011%\u0011\u0019\u0007JI\u0001\n\u0003\ti\nC\u0005\u0003f\u0011\n\n\u0011\"\u0001\u0002\u001e\"9!q\r\u0013\u0005\u0002\t%\u0004bBA9I\u0011\u0005!Q\u000f\u0005\b\u0005G#C\u0011\u0001BS\u0011\u001d\u00119\r\nC!\u0005\u0013\fAbQ9m\r>\u0014X.\u0019;uKJT!a\u0017/\u0002\u0013\r\f7o]1oIJ\f'BA/_\u0003!QX\r\u001d9fY&t'BA0a\u0003\u0019\t\u0007/Y2iK*\t\u0011-A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002e\u00035\t!L\u0001\u0007Dc24uN]7biR,'o\u0005\u0002\u0002OB\u0011\u0001n[\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A2\u0002!\u0011+e)Q+M)~#\u0016*T#[\u001f:+U#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001\u00027b]\u001eT\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yg\n11\u000b\u001e:j]\u001e\f\u0011\u0003R#G\u0003VcEk\u0018+J\u001b\u0016SvJT#!\u00039!UIR!V\u0019R{fi\u0014*N\u0003R\u000bq\u0002R#G\u0003VcEk\u0018$P%6\u000bE\u000bI\u0001\u0018\t\u00163\u0015)\u0016'U?\u001acu*\u0011+`!J+5)S*J\u001f:+\u0012A \t\u0003Q~L1!!\u0001j\u0005\rIe\u000e^\u0001\u0019\t\u00163\u0015)\u0016'U?\u001acu*\u0011+`!J+5)S*J\u001f:\u0003\u0013\u0001\u0007#F\r\u0006+F\nV0E\u001fV\u0013E*R0Q%\u0016\u001b\u0015jU%P\u001d\u0006IB)\u0012$B+2#v\fR(V\u00052+u\f\u0015*F\u0007&\u001b\u0016j\u0014(!\u0003e!UIR!V\u0019R{F)R\"J\u001b\u0006cu\f\u0015*F\u0007&\u001b\u0016j\u0014(\u00025\u0011+e)Q+M)~#UiQ%N\u00032{\u0006KU#D\u0013NKuJ\u0014\u0011\u00021\u0011+e)Q+M)~#\u0016*T#T)\u0006k\u0005k\u0018$P%6\u000bE+A\rE\u000b\u001a\u000bU\u000b\u0014+`)&kUi\u0015+B\u001bB{fi\u0014*N\u0003R\u0003\u0013a\u0005#F\r\u0006+F\nV0U\u00136+uLR(S\u001b\u0006#\u0016\u0001\u0006#F\r\u0006+F\nV0U\u00136+uLR(S\u001b\u0006#\u0006%A\nE\u000b\u001a\u000bU\u000b\u0014+`\t\u0006#Vi\u0018$P%6\u000bE+\u0001\u000bE\u000b\u001a\u000bU\u000b\u0014+`\t\u0006#Vi\u0018$P%6\u000bE\u000bI\u0001\u000f\t\u00163\u0015)\u0016'U?2{5)\u0011'F\u0003=!UIR!V\u0019R{FjT\"B\u0019\u0016\u0003\u0013!F1mY\u00063\u0018-\u001b7bE2,G+[7fu>tWm]\u000b\u0003\u0003C\u0001b!a\t\u00022\u0005]b\u0002BA\u0013\u0003[\u00012!a\nj\u001b\t\tICC\u0002\u0002,\t\fa\u0001\u0010:p_Rt\u0014bAA\u0018S\u00061\u0001K]3eK\u001aLA!a\r\u00026\t\u00191+\u001a;\u000b\u0007\u0005=\u0012\u000e\u0005\u0003\u0002$\u0005e\u0012b\u0001=\u00026\u00051\u0012\r\u001c7Bm\u0006LG.\u00192mKRKW.\u001a>p]\u0016\u001c\b%\u0001\nhKRtU/\u001c2fe\u001a{'/\\1ui\u0016\u0014HCBA!\u0003'\n\u0019\u0007E\u0003i\u0003\u0007\n9%C\u0002\u0002F%\u0014aa\u00149uS>t\u0007\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055S/\u0001\u0003uKb$\u0018\u0002BA)\u0003\u0017\u0012Q\u0002R3dS6\fGNR8s[\u0006$\bbBA+/\u0001\u0007\u0011qK\u0001\u0007Y>\u001c\u0017\r\\3\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018v\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00141\f\u0002\u0007\u0019>\u001c\u0017\r\\3\t\r\u0005\u0015t\u00031\u0001\u007f\u0003%\u0001(/Z2jg&|g.\u0001\u000bhKR$\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u000b\t\u0003W\nY(! \u0002\nB!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014A\u00024pe6\fGOC\u0002\u0002vU\fA\u0001^5nK&!\u0011\u0011PA8\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\b\u0003+B\u0002\u0019AA,\u0011\u001d\ty\b\u0007a\u0001\u0003\u0003\u000b\u0001\u0002^5nKj{g.\u001a\t\u0005\u0003\u0007\u000b))\u0004\u0002\u0002t%!\u0011qQA:\u0005\u0019QvN\\3JI\"9\u0011\u0011\u000f\rA\u0002\u0005]\u0012!C4fi2{7-\u00197f)\u0011\t9&a$\t\u000f\u0005E\u0015\u00041\u0001\u00028\u0005IAn\\2bY\u0016\u001cFO]\u0001\fO\u0016$H+[7fu>tW\r\u0006\u0003\u0002\u0002\u0006]\u0005bBAM5\u0001\u0007\u0011qG\u0001\u0006ij\u001cFO]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%\u0006BA\u001c\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[K\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]&f\u0001@\u0002\"\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sM\u0011AeZ\u0001\r_V$\b/\u001e;G_Jl\u0017\r^\u000b\u0003\u0003o\tQb\\;uaV$hi\u001c:nCR\u0004\u0013A\u00044m_\u0006$\bK]3dSNLwN\\\u0001\u0010M2|\u0017\r\u001e)sK\u000eL7/[8oA\u0005yAm\\;cY\u0016\u0004&/Z2jg&|g.\u0001\te_V\u0014G.\u001a)sK\u000eL7/[8oA\u0005\u0001B-Z2j[\u0006d\u0007K]3dSNLwN\\\u0001\u0012I\u0016\u001c\u0017.\\1m!J,7-[:j_:\u0004\u0013a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0002!QLW.Z:uC6\u0004hi\u001c:nCR\u0004\u0013A\u0003;j[\u00164uN]7bi\u0006YA/[7f\r>\u0014X.\u0019;!\u0003)!\u0017\r^3G_Jl\u0017\r^\u0001\fI\u0006$XMR8s[\u0006$\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012\f1\u0002^5nKj{g.Z%eA\u0005QAn\\2bY\u0016\u001cFO\u001d\u0011\u0015)\u0005=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\u0018q B\u0001!\t!G\u0005C\u0005\u0002J^\u0002\n\u00111\u0001\u00028!A\u0011qZ\u001c\u0011\u0002\u0003\u0007a\u0010\u0003\u0005\u0002T^\u0002\n\u00111\u0001\u007f\u0011!\t9n\u000eI\u0001\u0002\u0004q\b\"CAnoA\u0005\t\u0019AA\u001c\u0011%\tyn\u000eI\u0001\u0002\u0004\t9\u0004C\u0005\u0002d^\u0002\n\u00111\u0001\u00028!I\u0011q]\u001c\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0003#;\u0004\u0013!a\u0001\u0003o\t1\"[:Dc24uN]7biV\u0011!q\u0001\t\u0004Q\n%\u0011b\u0001B\u0006S\n9!i\\8mK\u0006t\u0017\u0001D5t\u0007Fdgi\u001c:nCR\u0004SCAA,\u0003\u001dawnY1mK\u0002*\"!!!\u0002\u0013QLW.\u001a.p]\u0016\u0004\u0013A\u00044m_\u0006$hi\u001c:nCR$XM]\u000b\u0003\u0003\u0003\nqB\u001a7pCR4uN]7biR,'\u000fI\u0001\u0010I>,(\r\\3G_Jl\u0017\r\u001e;fe\u0006\u0001Bm\\;cY\u00164uN]7biR,'\u000fI\u0001\u0011I\u0016\u001c\u0017.\\1m\r>\u0014X.\u0019;uKJ\f\u0011\u0003Z3dS6\fGNR8s[\u0006$H/\u001a:!\u0003I!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0016\u0005\u0005-\u0014a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0004;j[\u00164uN]7biR,'/\u0001\buS6,gi\u001c:nCR$XM\u001d\u0011\u0002\u001b\u0011\fG/\u001a$pe6\fG\u000f^3s\u00039!\u0017\r^3G_Jl\u0017\r\u001e;fe\u0002\"B!a<\u00036!9!q\u0007&A\u0002\te\u0012A\u00039s_B,'\u000f^5fgB!\u0011\u0011\fB\u001e\u0013\u0011\u0011i$a\u0017\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0003d_BLH\u0003FAx\u0005\u0007\u0012)Ea\u0012\u0003J\t-#Q\nB(\u0005#\u0012\u0019\u0006C\u0005\u0002J.\u0003\n\u00111\u0001\u00028!A\u0011qZ&\u0011\u0002\u0003\u0007a\u0010\u0003\u0005\u0002T.\u0003\n\u00111\u0001\u007f\u0011!\t9n\u0013I\u0001\u0002\u0004q\b\"CAn\u0017B\u0005\t\u0019AA\u001c\u0011%\tyn\u0013I\u0001\u0002\u0004\t9\u0004C\u0005\u0002d.\u0003\n\u00111\u0001\u00028!I\u0011q]&\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0003#[\u0005\u0013!a\u0001\u0003o\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nabY8qs\u0012\"WMZ1vYR$\u0003(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001d\u0002\u0017\u0019|'/\\1u\u0011Vl\u0017M\u001c\u000b\u0005\u0003o\u0011Y\u0007C\u0004\u0003nU\u0003\rAa\u001c\u0002\u0007=\u0014'\u000eE\u0002s\u0005cJ1Aa\u001dt\u0005\u0019y%M[3diR1\u0011q\u0007B<\u0005sBqA!\u001cW\u0001\u0004\u0011y\u0007C\u0004\u0003|Y\u0003\rA! \u0002\u000b\r|G-Z2\u0011\u000b\t}$qT4\u000e\u0005\t\u0005%\u0002\u0002B>\u0005\u0007SAA!\"\u0003\b\u0006!A/\u001f9f\u0015\u0011\u0011IIa#\u0002\t\r|'/\u001a\u0006\u0005\u0005\u001b\u0013y)A\u0002ba&TAA!%\u0003\u0014\u00061AM]5wKJTAA!&\u0003\u0018\u0006\u0019qn]:\u000b\t\te%1T\u0001\tI\u0006$\u0018m\u001d;bq*\u0011!QT\u0001\u0004G>l\u0017\u0002\u0002BQ\u0005\u0003\u0013\u0011\u0002V=qK\u000e{G-Z2\u0002!\u001d,GOV1mk\u0016\f5o\u0015;sS:<G\u0003CA\u001c\u0005O\u00139La/\t\u000f\t%v\u000b1\u0001\u0003,\u0006\u0019!o\\<\u0011\t\t5&1W\u0007\u0003\u0005_SAA!-\u0003\b\u0006\u00191-\u001d7\n\t\tU&q\u0016\u0002\u0004%><\bb\u0002B]/\u0002\u0007\u0011qG\u0001\u0005]\u0006lW\rC\u0004\u0003>^\u0003\rAa0\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004BA!1\u0003D6\u0011!1Q\u0005\u0005\u0005\u000b\u0014\u0019I\u0001\u0005ECR\fG+\u001f9f\u0003!!xn\u0015;sS:<GCAA\u001c\u0001")
public class CqlFormatter {
    private final String outputFormat;
    private final int floatPrecision;
    private final int doublePrecision;
    private final int decimalPrecision;
    private final String timestampFormat;
    private final String timeFormat;
    private final String dateFormat;
    private final String timeZoneId;
    private final String localeStr;
    private final boolean isCqlFormat;
    private final Locale locale;
    private final ZoneId timeZone;
    private final Option<DecimalFormat> floatFormatter;
    private final Option<DecimalFormat> doubleFormatter;
    private final Option<DecimalFormat> decimalFormatter;
    private final DateTimeFormatter timestampFormatter;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter dateFormatter;

    public static String $lessinit$greater$default$9() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$9();
    }

    public static String $lessinit$greater$default$8() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$8();
    }

    public static String $lessinit$greater$default$7() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$1();
    }

    public static ZoneId getTimezone(String string) {
        return CqlFormatter$.MODULE$.getTimezone(string);
    }

    public static Locale getLocale(String string) {
        return CqlFormatter$.MODULE$.getLocale(string);
    }

    public static DateTimeFormatter getDateTimeFormatter(Locale locale, ZoneId zoneId, String string) {
        return CqlFormatter$.MODULE$.getDateTimeFormatter(locale, zoneId, string);
    }

    public static Option<DecimalFormat> getNumberFormatter(Locale locale, int n) {
        return CqlFormatter$.MODULE$.getNumberFormatter(locale, n);
    }

    public static scala.collection.immutable.Set<String> allAvailableTimezones() {
        return CqlFormatter$.MODULE$.allAvailableTimezones();
    }

    public static String DEFAULT_LOCALE() {
        return CqlFormatter$.MODULE$.DEFAULT_LOCALE();
    }

    public static String DEFAULT_DATE_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_DATE_FORMAT();
    }

    public static String DEFAULT_TIME_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_TIME_FORMAT();
    }

    public static String DEFAULT_TIMESTAMP_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_TIMESTAMP_FORMAT();
    }

    public static int DEFAULT_DECIMAL_PRECISION() {
        return CqlFormatter$.MODULE$.DEFAULT_DECIMAL_PRECISION();
    }

    public static int DEFAULT_DOUBLE_PRECISION() {
        return CqlFormatter$.MODULE$.DEFAULT_DOUBLE_PRECISION();
    }

    public static int DEFAULT_FLOAT_PRECISION() {
        return CqlFormatter$.MODULE$.DEFAULT_FLOAT_PRECISION();
    }

    public static String DEFAULT_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_FORMAT();
    }

    public static String DEFAULT_TIMEZONE() {
        return CqlFormatter$.MODULE$.DEFAULT_TIMEZONE();
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public int floatPrecision() {
        return this.floatPrecision;
    }

    public int doublePrecision() {
        return this.doublePrecision;
    }

    public int decimalPrecision() {
        return this.decimalPrecision;
    }

    public String timestampFormat() {
        return this.timestampFormat;
    }

    public String timeFormat() {
        return this.timeFormat;
    }

    public String dateFormat() {
        return this.dateFormat;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public String localeStr() {
        return this.localeStr;
    }

    public boolean isCqlFormat() {
        return this.isCqlFormat;
    }

    public Locale locale() {
        return this.locale;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public Option<DecimalFormat> floatFormatter() {
        return this.floatFormatter;
    }

    public Option<DecimalFormat> doubleFormatter() {
        return this.doubleFormatter;
    }

    public Option<DecimalFormat> decimalFormatter() {
        return this.decimalFormatter;
    }

    public DateTimeFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    public DateTimeFormatter timeFormatter() {
        return this.timeFormatter;
    }

    public DateTimeFormatter dateFormatter() {
        return this.dateFormatter;
    }

    public CqlFormatter copy(String outputFormat, int floatPrecision, int doublePrecision, int decimalPrecision, String timestampFormat, String timeFormat, String dateFormat, String timeZoneId, String localeStr) {
        return new CqlFormatter(outputFormat, floatPrecision, doublePrecision, decimalPrecision, timestampFormat, timeFormat, dateFormat, timeZoneId, localeStr);
    }

    public String copy$default$1() {
        return this.outputFormat();
    }

    public int copy$default$2() {
        return this.floatPrecision();
    }

    public int copy$default$3() {
        return this.doublePrecision();
    }

    public int copy$default$4() {
        return this.decimalPrecision();
    }

    public String copy$default$5() {
        return this.timestampFormat();
    }

    public String copy$default$6() {
        return this.timeFormat();
    }

    public String copy$default$7() {
        return this.dateFormat();
    }

    public String copy$default$8() {
        return this.timeZoneId();
    }

    public String copy$default$9() {
        return this.localeStr();
    }

    public String formatHuman(Object obj) {
        if (obj == null) {
            return "null";
        }
        Object object = obj;
        if (object instanceof Float) {
            Float f = (Float)object;
            Option<DecimalFormat> option = this.floatFormatter();
            if (None$.MODULE$.equals(option)) {
                return Float.toString(Predef$.MODULE$.Float2float(f));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                DecimalFormat fmt = (DecimalFormat)some.value();
                return fmt.format(f);
            }
            throw new MatchError(option);
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            Option<DecimalFormat> option = this.doubleFormatter();
            if (None$.MODULE$.equals(option)) {
                return Double.toString(Predef$.MODULE$.Double2double(d));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                DecimalFormat fmt = (DecimalFormat)some.value();
                return fmt.format(d);
            }
            throw new MatchError(option);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            Option<DecimalFormat> option = this.decimalFormatter();
            if (None$.MODULE$.equals(option)) {
                return bigDecimal.toString();
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                DecimalFormat fmt = (DecimalFormat)some.value();
                return fmt.format(bigDecimal);
            }
            throw new MatchError(option);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    return new StringBuilder(2).append(this.formatHuman(k)).append(": ").append(this.formatHuman(v)).toString();
                }
                throw new MatchError(tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        }
        if (object instanceof List) {
            List list = (List)object;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1<Object, String> & Serializable & scala.Serializable)x -> this.formatHuman(x), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(set).asScala()).map((Function1<Object, String> & Serializable & scala.Serializable)x -> this.formatHuman(x), Set$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return this.timestampFormatter().format(instant.atZone(this.timeZone()));
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return this.dateFormatter().format(localDate);
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return this.timeFormatter().format(localTime);
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            return new StringBuilder(2).append("0x").append(ByteBufUtil.hexDump(byteBuffer.array())).toString();
        }
        if (object instanceof InetAddress) {
            InetAddress inetAddress = (InetAddress)object;
            return inetAddress.getHostAddress();
        }
        if (object instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)object;
            return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tupleValue.size()).map((Function1<Object, String> & Serializable & scala.Serializable)i -> this.formatHuman(tupleValue.getObject(BoxesRunTime.unboxToInt(i))), IndexedSeq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")");
        }
        if (object instanceof UdtValue) {
            UdtValue udtValue = (UdtValue)object;
            List<CqlIdentifier> names = udtValue.getType().getFieldNames();
            return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), udtValue.size()).map((Function1<Object, String> & Serializable & scala.Serializable)i -> CqlFormatter.$anonfun$formatHuman$5(this, names, udtValue, BoxesRunTime.unboxToInt(i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        }
        return obj.toString();
    }

    public String format(Object obj, TypeCodec<Object> codec) {
        if (this.isCqlFormat()) {
            return codec.format(obj);
        }
        return this.formatHuman(new Tuple2<Object, TypeCodec<Object>>(obj, codec));
    }

    public String getValueAsString(Row row, String name, DataType dataType) {
        Object value = row.getObject(name);
        if (this.isCqlFormat()) {
            return this.format(value, row.codecRegistry().codecFor(dataType, value));
        }
        return this.formatHuman(value);
    }

    public String toString() {
        return new StringBuilder(93).append("CqlFormatter(format=").append(this.outputFormat()).append(", fp=").append(this.floatPrecision()).append(", dp=").append(this.doublePrecision()).append(", ").append(", dcp=").append(this.decimalPrecision()).append(", tsFormat=").append(this.timestampFormat()).append(", tmFormat=").append(this.timeFormat()).append(", dtFormat=").append(this.dateFormat()).append(", ").append("timeozone=").append(this.timeZoneId()).append(", locale=").append(this.localeStr()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$formatHuman$5(CqlFormatter $this, List names$1, UdtValue x14$1, int i) {
        return new StringBuilder(2).append(((CqlIdentifier)names$1.get(i)).asInternal()).append(": ").append($this.formatHuman(x14$1.getObject(i))).toString();
    }

    public CqlFormatter(String outputFormat, int floatPrecision, int doublePrecision, int decimalPrecision, String timestampFormat, String timeFormat, String dateFormat, String timeZoneId, String localeStr) {
        this.outputFormat = outputFormat;
        this.floatPrecision = floatPrecision;
        this.doublePrecision = doublePrecision;
        this.decimalPrecision = decimalPrecision;
        this.timestampFormat = timestampFormat;
        this.timeFormat = timeFormat;
        this.dateFormat = dateFormat;
        this.timeZoneId = timeZoneId;
        this.localeStr = localeStr;
        this.isCqlFormat = "cql".equalsIgnoreCase(outputFormat);
        this.locale = CqlFormatter$.MODULE$.getLocale(localeStr);
        this.timeZone = CqlFormatter$.MODULE$.getTimezone(timeZoneId);
        this.floatFormatter = CqlFormatter$.MODULE$.getNumberFormatter(this.locale(), floatPrecision);
        this.doubleFormatter = CqlFormatter$.MODULE$.getNumberFormatter(this.locale(), doublePrecision);
        this.decimalFormatter = CqlFormatter$.MODULE$.getNumberFormatter(this.locale(), decimalPrecision);
        this.timestampFormatter = CqlFormatter$.MODULE$.getDateTimeFormatter(this.locale(), this.timeZone(), timestampFormat);
        this.timeFormatter = CqlFormatter$.MODULE$.getDateTimeFormatter(this.locale(), this.timeZone(), timeFormat);
        this.dateFormatter = CqlFormatter$.MODULE$.getDateTimeFormatter(this.locale(), this.timeZone(), dateFormat);
    }

    public CqlFormatter(Properties properties) {
        this(properties.getProperty("cassandra.format.output", CqlFormatter$.MODULE$.DEFAULT_FORMAT()), new StringOps(Predef$.MODULE$.augmentString(properties.getProperty("cassandra.format.float_precision", Integer.toString(CqlFormatter$.MODULE$.DEFAULT_FLOAT_PRECISION())))).toInt(), new StringOps(Predef$.MODULE$.augmentString(properties.getProperty("cassandra.format.double_precision", Integer.toString(CqlFormatter$.MODULE$.DEFAULT_DOUBLE_PRECISION())))).toInt(), new StringOps(Predef$.MODULE$.augmentString(properties.getProperty("cassandra.format.decimal_precision", Integer.toString(CqlFormatter$.MODULE$.DEFAULT_DECIMAL_PRECISION())))).toInt(), properties.getProperty("cassandra.format.timestamp", CqlFormatter$.MODULE$.DEFAULT_TIMESTAMP_FORMAT()), properties.getProperty("cassandra.format.time", CqlFormatter$.MODULE$.DEFAULT_TIME_FORMAT()), properties.getProperty("cassandra.format.date", CqlFormatter$.MODULE$.DEFAULT_DATE_FORMAT()), properties.getProperty("cassandra.format.timezone", CqlFormatter$.MODULE$.DEFAULT_TIMEZONE()), properties.getProperty("cassandra.format.locale", CqlFormatter$.MODULE$.DEFAULT_LOCALE()));
    }
}

