/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.apache.zeppelin.scheduler.FIFOScheduler;
import org.apache.zeppelin.scheduler.ParallelScheduler;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerFactory.class);
    private static final String SCHEDULER_EXECUTOR_NAME = "SchedulerFactory";
    protected ExecutorService executor;
    protected Map<String, Scheduler> schedulers = new HashMap<String, Scheduler>();

    public static SchedulerFactory singleton() {
        return InstanceHolder.INSTANCE;
    }

    private SchedulerFactory() {
        int threadPoolSize = ZeppelinConfiguration.getStaticInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_SCHEDULER_POOL_SIZE);
        LOGGER.info("Scheduler Thread Pool Size: {}", (Object)threadPoolSize);
        this.executor = ExecutorFactory.singleton().createOrGet(SCHEDULER_EXECUTOR_NAME, threadPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LOGGER.info("Destroy all executors");
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            for (Map.Entry<String, Scheduler> scheduler : this.schedulers.entrySet()) {
                LOGGER.info("Stopping Scheduler {}", (Object)scheduler.getKey());
                scheduler.getValue().stop();
            }
            this.schedulers.clear();
        }
        ExecutorUtil.softShutdown("SchedulerFactoryExecutor", this.executor, 60, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetFIFOScheduler(String name) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            return this.schedulers.computeIfAbsent(name, k -> {
                LOGGER.info("Create FIFOScheduler: {}", k);
                FIFOScheduler s = new FIFOScheduler((String)k);
                this.executor.execute(s);
                return s;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetParallelScheduler(String name, int maxConcurrency) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            return this.schedulers.computeIfAbsent(name, k -> {
                LOGGER.info("Create ParallelScheduler: {} with maxConcurrency: {}", k, (Object)maxConcurrency);
                ParallelScheduler s = new ParallelScheduler((String)k, maxConcurrency);
                this.executor.execute(s);
                return s;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetScheduler(Scheduler scheduler) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            return this.schedulers.computeIfAbsent(scheduler.getName(), k -> {
                this.executor.execute(scheduler);
                return scheduler;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScheduler(String name) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            LOGGER.info("Remove scheduler: {}", (Object)name);
            Scheduler s = this.schedulers.remove(name);
            if (s != null) {
                s.stop();
            }
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    private static final class InstanceHolder {
        private static final SchedulerFactory INSTANCE = new SchedulerFactory();

        private InstanceHolder() {
        }
    }
}

